/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.DemonFlyingToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class ReignOfThePitEffect
extends OneShotEffect {
    ReignOfThePitEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "Each player sacrifices a creature. Create an X/X black Demon creature token with flying, where X is the total power of the creatures sacrificed this way";
    }

    private ReignOfThePitEffect(ReignOfThePitEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReignOfThePitEffect copy() {
        return new ReignOfThePitEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int totalPowerSacrificed = 0;
        ArrayList perms = new ArrayList();
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            TargetSacrifice target;
            Player player = game.getPlayer(playerId);
            if (player == null || !(target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE)).canChoose(player.getId(), source, game)) continue;
            while (!target.isChosen(game) && player.canRespond()) {
                player.choose(Outcome.Sacrifice, (Target)target, source, game);
            }
            perms.addAll(target.getTargets());
        }
        for (UUID permID : perms) {
            Permanent permanent = game.getPermanent(permID);
            if (permanent == null) continue;
            int power = permanent.getPower().getValue();
            if (!permanent.sacrifice(source, game)) continue;
            totalPowerSacrificed += power;
        }
        new CreateTokenEffect((Token)new DemonFlyingToken(totalPowerSacrificed)).apply(game, source);
        return true;
    }
}

