/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class ReincarnationEffect
extends OneShotEffect {
    ReincarnationEffect() {
        super(Outcome.Detriment);
        this.staticText = "return a creature card from its owner's graveyard to the battlefield under the control of that creature's owner";
    }

    private ReincarnationEffect(ReincarnationEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReincarnationEffect copy() {
        return new ReincarnationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        Player owner = game.getPlayer(game.getOwnerId(this.getTargetPointer().getFirst(game, source)));
        if (controller == null || owner == null) {
            return false;
        }
        FilterCreatureCard filter = new FilterCreatureCard("a creature card from " + owner.getName() + "'s graveyard");
        filter.add((Predicate)new OwnerIdPredicate(owner.getId()));
        TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)filter);
        target.withNotTarget(true);
        if (target.canChoose(controller.getId(), source, game) && controller.chooseTarget(this.outcome, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null && game.getState().getZone(card.getId()) == Zone.GRAVEYARD) {
            controller.moveCards(card, Zone.BATTLEFIELD, source, game, false, false, true, null);
        }
        return true;
    }
}

