/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.token.SpiritToken;
import mage.players.Player;

class ReleaseToMemoryEffect
extends OneShotEffect {
    ReleaseToMemoryEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile target opponent's graveyard. For each creature card exiled this way, create a 1/1 colorless Spirit creature token";
    }

    private ReleaseToMemoryEffect(ReleaseToMemoryEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReleaseToMemoryEffect copy() {
        return new ReleaseToMemoryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player == null) {
            return false;
        }
        int creatures = player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
        player.moveCards((Cards)player.getGraveyard(), Zone.EXILED, source, game);
        if (creatures > 0) {
            game.processAction();
            new SpiritToken().putOntoBattlefield(creatures, game, source);
        }
        return true;
    }
}

