/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;

class RemKarolusStalwartSlayerPreventionEffect
extends PreventionEffectImpl {
    RemKarolusStalwartSlayerPreventionEffect() {
        super(Duration.WhileOnBattlefield, Integer.MAX_VALUE, false, false);
        this.staticText = "If a spell would deal damage to you or another permanent you control, prevent that damage";
    }

    private RemKarolusStalwartSlayerPreventionEffect(RemKarolusStalwartSlayerPreventionEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public RemKarolusStalwartSlayerPreventionEffect copy() {
        return new RemKarolusStalwartSlayerPreventionEffect(this);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        UUID targetId = event.getTargetId();
        if (targetId.equals(source.getSourceId())) {
            return false;
        }
        UUID controllerId = source.getControllerId();
        if (!(targetId.equals(controllerId) || (permanent = game.getPermanent(targetId)) != null && permanent.isControlledBy(controllerId))) {
            return false;
        }
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        if (stackObject == null) {
            stackObject = (StackObject)game.getLastKnownInformation(event.getSourceId(), Zone.STACK);
        }
        if (stackObject instanceof Spell) {
            return super.applies(event, source, game);
        }
        return false;
    }
}

