/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.util.CardUtil;

class RemKarolusStalwartSlayerReplacementEffect
extends ReplacementEffectImpl {
    RemKarolusStalwartSlayerReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If a spell would deal damage to an opponent or a permanent an opponent controls, it deals that much damage plus 1 instead";
    }

    private RemKarolusStalwartSlayerReplacementEffect(RemKarolusStalwartSlayerReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public RemKarolusStalwartSlayerReplacementEffect copy() {
        return new RemKarolusStalwartSlayerReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)1));
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PERMANENT: 
            case DAMAGE_PLAYER: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        UUID targetId = event.getTargetId();
        Set opponents = game.getOpponents(source.getControllerId());
        if (!(opponents.contains(targetId) || (permanent = game.getPermanent(targetId)) != null && opponents.contains(permanent.getControllerId()))) {
            return false;
        }
        StackObject stackObject = game.getStack().getStackObject(event.getSourceId());
        if (stackObject == null) {
            stackObject = (StackObject)game.getLastKnownInformation(event.getSourceId(), Zone.STACK);
        }
        return stackObject instanceof Spell;
    }
}

