/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RemnantOfTheRisingStarEffect
extends OneShotEffect {
    RemnantOfTheRisingStarEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may pay {X}. When you do, put X +1/+1 counters on that creature";
    }

    private RemnantOfTheRisingStarEffect(RemnantOfTheRisingStarEffect effect) {
        super((OneShotEffect)effect);
    }

    public RemnantOfTheRisingStarEffect copy() {
        return new RemnantOfTheRisingStarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        ManaCostsImpl cost = new ManaCostsImpl("{X}");
        if (player == null || !player.chooseUse(Outcome.BoostCreature, "Pay " + cost.getText() + "?", source, game)) {
            return false;
        }
        int xValue = player.announceX(0, Integer.MAX_VALUE, "Announce the value for {X} (pay to add counters)", game, source, true);
        cost.add((Object)new GenericManaCost(xValue));
        if (!cost.pay(source, game, source, source.getControllerId(), false, null)) {
            return false;
        }
        Permanent permanent = (Permanent)this.getValue("permanentEnteringBattlefield");
        if (permanent == null) {
            return false;
        }
        game.fireReflexiveTriggeredAbility(new ReflexiveTriggeredAbility((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance(xValue)).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), false), source);
        return true;
    }
}

