/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RendingVinesEffect
extends OneShotEffect {
    RendingVinesEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target artifact or enchantment if its mana value is less than or equal to the number of cards in your hand";
    }

    private RendingVinesEffect(RendingVinesEffect effect) {
        super((OneShotEffect)effect);
    }

    public RendingVinesEffect copy() {
        return new RendingVinesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && permanent.getManaValue() <= controller.getHand().size()) {
            return permanent.destroy(source, game, false);
        }
        return false;
    }
}

