/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.r.RenegadeDoppelgangerEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RenegadeDoppelgangerTriggeredAbility
extends TriggeredAbilityImpl {
    RenegadeDoppelgangerTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new RenegadeDoppelgangerEffect(), true);
    }

    private RenegadeDoppelgangerTriggeredAbility(RenegadeDoppelgangerTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RenegadeDoppelgangerTriggeredAbility copy() {
        return new RenegadeDoppelgangerTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        if (!event.getTargetId().equals(this.getSourceId()) && (permanent = game.getPermanent(event.getTargetId())) != null && permanent.isCreature(game) && permanent.isControlledBy(this.getControllerId())) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever another creature you control enters, you may have {this} become a copy of that creature until end of turn.";
    }
}

