/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class RenownedWeaponsmithEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("card named Heart-Piercer Vial of Dragonfire");

    public RenownedWeaponsmithEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Search your library for a card named Heart-Piercer Bow or Vial of Dragonfire, reveal it, put it into your hand, then shuffle";
    }

    private RenownedWeaponsmithEffect(RenownedWeaponsmithEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null && controller != null) {
            TargetCardInLibrary target = new TargetCardInLibrary(filter);
            if (controller.searchLibrary(target, source, game) && !target.getTargets().isEmpty()) {
                CardsImpl revealed = new CardsImpl();
                Card card = game.getCard(target.getFirstTarget());
                if (card != null) {
                    revealed.add(card);
                    controller.revealCards(sourceObject.getIdName(), (Cards)revealed, game);
                    controller.moveCards((Cards)revealed, Zone.HAND, source, game);
                }
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    public RenownedWeaponsmithEffect copy() {
        return new RenownedWeaponsmithEffect(this);
    }

    static {
        filter.add(Predicates.or((Predicate)new NamePredicate("Heart-Piercer Bow"), (Predicate)new NamePredicate("Vial of Dragonfire")));
    }
}

