/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class RepopulateEffect
extends OneShotEffect {
    RepopulateEffect() {
        super(Outcome.Benefit);
        this.staticText = "Shuffle all creature cards from target player's graveyard into that player's library";
    }

    private RepopulateEffect(RepopulateEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player != null) {
            return player.shuffleCardsToLibrary((Cards)new CardsImpl(player.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game)), game, source);
        }
        return false;
    }

    public RepopulateEffect copy() {
        return new RepopulateEffect(this);
    }
}

