/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class RescuerSphinxEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent("nonland permanent you control");

    RescuerSphinxEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may return a nonland permanent you control to its owner's hand. If you do, {this} enters with a +1/+1 counter on it.";
    }

    private RescuerSphinxEffect(RescuerSphinxEffect effect) {
        super((OneShotEffect)effect);
    }

    public RescuerSphinxEffect copy() {
        return new RescuerSphinxEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (!player.chooseUse(this.outcome, "Return a nonland permanent you control to your hand?", source, game)) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, 1, filter, true);
        if (!player.choose(this.outcome, (Target)target, source, game)) {
            return false;
        }
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent == null || !player.moveCards((Card)permanent, Zone.HAND, source, game)) {
            return false;
        }
        return new AddCountersSourceEffect(CounterType.P1P1.createInstance()).apply(game, source);
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.LAND.getPredicate()));
    }
}

