/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.MultiAmountType;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.util.MultiAmountMessage;

class ResourcefulDefenseMoveCounterEffect
extends OneShotEffect {
    ResourcefulDefenseMoveCounterEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Move any number of counters from target permanent you control to another target permanent you control";
    }

    private ResourcefulDefenseMoveCounterEffect(ResourcefulDefenseMoveCounterEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        List choices;
        int total;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent fromPermanent = game.getPermanent(source.getFirstTarget());
        Permanent toPermanent = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        if (controller == null || fromPermanent == null || toPermanent == null) {
            return false;
        }
        ArrayList<Counter> counters = new ArrayList<Counter>(fromPermanent.getCounters(game).values());
        counters.sort(Comparator.comparing(Counter::getName));
        List messages = counters.stream().map(c -> new MultiAmountMessage(c.getName() + " (" + c.getCount() + ")", 0, c.getCount())).collect(Collectors.toList());
        int totalMin = 0;
        int totalMax = messages.stream().mapToInt(m -> m.max).sum();
        while ((total = (choices = controller.getMultiAmountWithIndividualConstraints(Outcome.Neutral, messages, totalMin, totalMax, MultiAmountType.COUNTERS, game)).stream().mapToInt(x -> x).sum()) < totalMin && controller.canRespond()) {
        }
        for (int i = 0; i < choices.size(); ++i) {
            Integer amount = (Integer)choices.get(i);
            if (amount <= 0) continue;
            String counterName = ((Counter)counters.get(i)).getName();
            toPermanent.addCounters(CounterType.findByName((String)counterName).createInstance(amount.intValue()), source, game);
            fromPermanent.removeCounters(counterName, amount.intValue(), source, game);
            game.informPlayers(controller.getLogName() + "moved " + amount + " " + counterName + " counter" + (amount > 1 ? "s" : "") + " from " + fromPermanent.getLogName() + "to " + toPermanent.getLogName() + ".");
        }
        return true;
    }

    public ResourcefulDefenseMoveCounterEffect copy() {
        return new ResourcefulDefenseMoveCounterEffect(this);
    }
}

