/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CanBeEnchantedByPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class RetetherEffect
extends OneShotEffect {
    private static final FilterCard filterAura = new FilterCard("Aura card from your graveyard");

    public RetetherEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Return each Aura card from your graveyard to the battlefield. Only creatures can be enchanted this way";
    }

    private RetetherEffect(RetetherEffect effect) {
        super((OneShotEffect)effect);
    }

    public RetetherEffect copy() {
        return new RetetherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashMap<Card, Permanent> auraMap = new HashMap<Card, Permanent>();
            for (Card card : controller.getGraveyard().getCards(filterAura, source.getControllerId(), source, game)) {
                if (card == null) continue;
                FilterCreaturePermanent filter = new FilterCreaturePermanent("creature to enchant (" + card.getLogName() + ')');
                filter.add((Predicate)new CanBeEnchantedByPredicate((MageObject)card));
                Target target = null;
                block1: for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                    for (Permanent permanent : game.getBattlefield().getAllActivePermanents((FilterPermanent)filter, playerId, game)) {
                        if (permanent == null) continue;
                        for (Ability ability : card.getAbilities()) {
                            if (!(ability instanceof SpellAbility)) continue;
                            for (Target abilityTarget : ability.getTargets()) {
                                if (!abilityTarget.possibleTargets(controller.getId(), source, game).contains(permanent.getId())) continue;
                                target = abilityTarget.copy();
                                break block1;
                            }
                        }
                    }
                }
                if (target != null) {
                    target.getFilter().add((Predicate)CardType.CREATURE.getPredicate());
                    target.withNotTarget(true);
                    if (target.canChoose(controller.getId(), source, game)) {
                        Permanent permanent;
                        target.withTargetName("creature to enchant (" + card.getLogName() + ')');
                        if (controller.choose(Outcome.PutCardInPlay, target, source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null && !permanent.cantBeAttachedBy((MageObject)card, source, game, true)) {
                            auraMap.put(card, permanent);
                            game.getState().setValue("attachTo:" + card.getId(), (Object)permanent);
                            continue;
                        }
                    }
                }
                game.informPlayers("No valid creature targets for " + card.getLogName());
            }
            controller.moveCards(auraMap.keySet(), Zone.BATTLEFIELD, source, game);
            for (Map.Entry entry : auraMap.entrySet()) {
                Card aura = (Card)entry.getKey();
                Permanent permanent = (Permanent)entry.getValue();
                if (aura == null || permanent == null) continue;
                permanent.addAttachment(aura.getId(), source, game);
            }
            return true;
        }
        return false;
    }

    static {
        filterAura.add((Predicate)CardType.ENCHANTMENT.getPredicate());
        filterAura.add((Predicate)SubType.AURA.getPredicate());
    }
}

