/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.util.ManaUtil;

class RethinkEffect
extends OneShotEffect {
    RethinkEffect() {
        super(Outcome.Detriment);
        this.staticText = "Counter target spell unless its controller pays {X}, where X is its mana value";
    }

    private RethinkEffect(RethinkEffect effect) {
        super((OneShotEffect)effect);
    }

    public RethinkEffect copy() {
        return new RethinkEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        StackObject spell = game.getStack().getStackObject(this.getTargetPointer().getFirst(game, source));
        if (spell != null && (player = game.getPlayer(spell.getControllerId())) != null) {
            ManaCost cost = ManaUtil.createManaCost((int)spell.getManaValue(), (boolean)true);
            if (!cost.pay(source, game, source, player.getId(), false)) {
                game.getStack().counter(spell.getId(), source, game);
            }
            return true;
        }
        return false;
    }
}

