/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetImpl;
import mage.target.TargetPermanent;

class RetributionEffect
extends OneShotEffect {
    RetributionEffect() {
        super(Outcome.Detriment);
        this.staticText = "Choose two target creatures an opponent controls. That player chooses and sacrifices one of those creatures. Put a -1/-1 counter on the other";
    }

    private RetributionEffect(RetributionEffect effect) {
        super((OneShotEffect)effect);
    }

    public RetributionEffect copy() {
        return new RetributionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent toSacrifice;
        List permanents = this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        List canSac = permanents.stream().filter(Permanent::canBeSacrificed).collect(Collectors.toList());
        switch (canSac.size()) {
            case 0: {
                toSacrifice = null;
                break;
            }
            case 1: {
                toSacrifice = (Permanent)canSac.get(0);
                break;
            }
            default: {
                toSacrifice = Optional.ofNullable(((Permanent)canSac.get(0)).getControllerId()).map(arg_0 -> ((Game)game).getPlayer(arg_0)).map(player -> {
                    FilterPermanent filter = new FilterPermanent();
                    filter.add((Predicate)new PermanentReferenceInCollectionPredicate((Collection)canSac, game));
                    TargetPermanent target = new TargetPermanent(filter);
                    target.withNotTarget(true);
                    player.choose(Outcome.Sacrifice, (Target)target, source, game);
                    return target;
                }).map(TargetImpl::getFirstTarget).map(arg_0 -> ((Game)game).getPermanent(arg_0)).orElse(null);
            }
        }
        if (toSacrifice != null) {
            permanents.remove(toSacrifice);
            toSacrifice.sacrifice(source, game);
        }
        for (Permanent permanent : permanents) {
            permanent.addCounters(CounterType.M1M1.createInstance(), source, game);
        }
        return true;
    }
}

