/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInYourGraveyard;

class ReturnFromExtinctionTarget
extends TargetCardInYourGraveyard {
    ReturnFromExtinctionTarget() {
        super(2, 2, (FilterCard)StaticFilters.FILTER_CARD_CREATURE, false);
        this.targetName = "creature cards that share a creature type from your graveyard";
    }

    private ReturnFromExtinctionTarget(ReturnFromExtinctionTarget target) {
        super((TargetCardInYourGraveyard)target);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        if (this.getTargets().isEmpty()) {
            return true;
        }
        Card targetOne = game.getCard((UUID)this.getTargets().get(0));
        Card targetTwo = game.getCard(id);
        if (targetOne == null || targetTwo == null) {
            return false;
        }
        return targetOne.shareCreatureTypes(game, (MageObject)targetTwo);
    }

    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        MageObject targetSource = game.getObject(source);
        Player player = game.getPlayer(sourceControllerId);
        if (player == null) {
            return false;
        }
        if (targetSource == null) {
            return false;
        }
        List cards = player.getGraveyard().getCards(this.filter, sourceControllerId, source, game).stream().collect(Collectors.toList());
        if (cards.size() < 2) {
            return false;
        }
        for (int i = 0; i < cards.size(); ++i) {
            for (int j = 0; j < cards.size(); ++j) {
                if (i <= j || !((Card)cards.get(i)).shareCreatureTypes(game, (MageObject)cards.get(j))) continue;
                return true;
            }
        }
        return false;
    }

    public ReturnFromExtinctionTarget copy() {
        return new ReturnFromExtinctionTarget(this);
    }
}

