/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RevengeEffect
extends OneShotEffect {
    RevengeEffect() {
        super(Outcome.BoostCreature);
    }

    private RevengeEffect(RevengeEffect effect) {
        super((OneShotEffect)effect);
    }

    public RevengeEffect copy() {
        return new RevengeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (target != null && target.isCreature(game)) {
            BoostTargetEffect effect = new BoostTargetEffect(4, 0, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(target.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }
}

