/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.common.FilterPermanentCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Library;
import mage.players.Player;

class ReweaveEffect
extends OneShotEffect {
    private static final FilterPermanentCard filter = new FilterPermanentCard();

    public ReweaveEffect() {
        super(Outcome.Detriment);
        this.staticText = "Target permanent's controller sacrifices it. If the player does, they reveal cards from the top of their library until they reveal a permanent card that shares a card type with the sacrificed permanent, put that card onto the battlefield, then shuffle";
    }

    private ReweaveEffect(ReweaveEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReweaveEffect copy() {
        return new ReweaveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = source.getSourceObject(game);
        if (permanent != null && sourceObject != null && permanent.sacrifice(source, game)) {
            Player permanentController = game.getPlayer(permanent.getControllerId());
            if (permanentController != null) {
                Library library = permanentController.getLibrary();
                if (library.hasCards()) {
                    CardsImpl cards = new CardsImpl();
                    Card permanentCard = null;
                    block0: for (Card card : permanentController.getLibrary().getCards(game)) {
                        cards.add(card);
                        if (!card.isPermanent(game)) continue;
                        for (CardType cardType : permanent.getCardType(game)) {
                            if (!card.getCardType(game).contains(cardType)) continue;
                            permanentCard = card;
                            continue block0;
                        }
                    }
                    permanentController.revealCards(source, (Cards)cards, game);
                    if (permanentCard != null) {
                        permanentController.moveCards(permanentCard, Zone.BATTLEFIELD, source, game);
                    }
                    permanentController.shuffleLibrary(source, game);
                }
                return true;
            }
            return false;
        }
        return true;
    }
}

