/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;

class RexCyberhoundTargetEffect
extends OneShotEffect {
    RexCyberhoundTargetEffect() {
        super(Outcome.Exile);
        this.staticText = "Choose target creature card in a graveyard. Exile it with a brain counter on it";
    }

    private RexCyberhoundTargetEffect(RexCyberhoundTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public RexCyberhoundTargetEffect copy() {
        return new RexCyberhoundTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (card == null || controller == null) {
            return false;
        }
        controller.moveCards(card, Zone.EXILED, source, game);
        if (game.getState().getZone(card.getId()) == Zone.EXILED) {
            card.addCounters(CounterType.BRAIN.createInstance(), source, game);
        }
        return true;
    }
}

