/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class ReyhanLastOfTheAbzanTriggeredAbility
extends TriggeredAbilityImpl {
    public ReyhanLastOfTheAbzanTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, true);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private ReyhanLastOfTheAbzanTriggeredAbility(ReyhanLastOfTheAbzanTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ReyhanLastOfTheAbzanTriggeredAbility copy() {
        return new ReyhanLastOfTheAbzanTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zcEvent = (ZoneChangeEvent)event;
        if (zcEvent.getFromZone() != Zone.BATTLEFIELD) {
            return false;
        }
        if (zcEvent.getToZone() != Zone.GRAVEYARD && zcEvent.getToZone() != Zone.COMMAND) {
            return false;
        }
        Permanent permanent = (Permanent)game.getLastKnownInformation(event.getTargetId(), Zone.BATTLEFIELD);
        if (permanent == null || !permanent.isCreature(game)) {
            return false;
        }
        Player player = game.getPlayer(this.getControllerId());
        if (player == null || !permanent.isControlledBy(this.getControllerId())) {
            return false;
        }
        int countersOn = permanent.getCounters(game).getCount(CounterType.P1P1);
        if (countersOn == 0) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance(countersOn)));
        return true;
    }

    public String getRule() {
        return "Whenever a creature you control dies or is put into the command zone, if it had one or more +1/+1 counters on it, you may put that many +1/+1 counters on target creature.";
    }
}

