/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.Mana;
import mage.abilities.ActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.mana.BasicManaEffect;
import mage.abilities.effects.mana.DoUnlessAnyPlayerPaysManaEffect;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.ActivatedManaAbilityImpl;
import mage.cards.r.RhysticCaveManaEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class RhysticCaveManaAbility
extends ActivatedManaAbilityImpl {
    public RhysticCaveManaAbility() {
        super(Zone.BATTLEFIELD, (ManaEffect)new DoUnlessAnyPlayerPaysManaEffect((ManaEffect)new RhysticCaveManaEffect(), (Cost)new GenericManaCost(1), "Pay {1} to prevent mana adding from {this}."), (Cost)new TapSourceCost());
        this.netMana.add(new Mana(0, 0, 0, 0, 0, 0, 1, 0));
        this.setUndoPossible(false);
    }

    public RhysticCaveManaAbility(Zone zone, Mana mana, Cost cost) {
        super(zone, (ManaEffect)new BasicManaEffect(mana), cost);
    }

    private RhysticCaveManaAbility(RhysticCaveManaAbility ability) {
        super((ActivatedManaAbilityImpl)ability);
    }

    public ActivatedAbility.ActivationStatus canActivate(UUID playerId, Game game) {
        Player player = game.getPlayer(playerId);
        if (player != null && !player.isInPayManaMode()) {
            return super.canActivate(playerId, game);
        }
        return ActivatedAbility.ActivationStatus.getFalse();
    }

    public RhysticCaveManaAbility copy() {
        return new RhysticCaveManaAbility(this);
    }

    public String getRule() {
        return super.getRule() + " Activate only as an instant.";
    }
}

