/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.SpellAbility;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;
import mage.target.Targets;

class RicochetEffect
extends OneShotEffect {
    RicochetEffect() {
        super(Outcome.Detriment);
        this.staticText = "each player rolls a six-sided die. Change the target of that spell to the player with the lowest result. Reroll to break ties, if necessary";
    }

    private RicochetEffect(RicochetEffect effect) {
        super((OneShotEffect)effect);
    }

    public RicochetEffect copy() {
        return new RicochetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getStack().getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            Targets targets = new Targets();
            SpellAbility sourceAbility = spell.getSpellAbility();
            for (Object modeId : sourceAbility.getModes().getSelectedModes()) {
                Mode mode = sourceAbility.getModes().get(modeId);
                targets.addAll((Collection)mode.getTargets());
            }
            if (targets.size() != 1 || ((Target)targets.get(0)).getTargets().size() != 1) {
                return false;
            }
            HashMap<Player, Integer> playerRolls = new HashMap<Player, Integer>();
            for (UUID playerId : game.getPlayerList().copy()) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                playerRolls.put(player, 7);
            }
            do {
                Object player2;
                for (Object player2 : playerRolls.keySet()) {
                    playerRolls.put((Player)player2, player2.rollDice(Outcome.Detriment, source, game, 6));
                }
                int minValueInMap = (Integer)Collections.min(playerRolls.values());
                player2 = new HashSet(playerRolls.entrySet()).iterator();
                while (player2.hasNext()) {
                    Map.Entry mapEntry = (Map.Entry)player2.next();
                    if ((Integer)mapEntry.getValue() <= minValueInMap) continue;
                    playerRolls.remove(mapEntry.getKey());
                }
            } while (playerRolls.size() > 1);
            if (playerRolls.size() == 1) {
                Player loser = (Player)playerRolls.keySet().toArray()[0];
                UUID loserId = loser.getId();
                Target target = (Target)targets.get(0);
                if (target.getFirstTarget().equals(loserId)) {
                    return true;
                }
                String oldTargetName = null;
                if (target.canTarget(spell.getControllerId(), loserId, (Ability)sourceAbility, game)) {
                    Player oldPlayer = game.getPlayer(targets.getFirstTarget());
                    if (oldPlayer != null) {
                        oldTargetName = oldPlayer.getLogName();
                    }
                    target.clearChosen();
                    target.addTarget(loserId, (Ability)sourceAbility, game);
                }
                MageObject sourceObject = game.getObject(source);
                if (oldTargetName != null && sourceObject != null) {
                    game.informPlayers(sourceObject.getLogName() + ": Changed target of " + spell.getLogName() + " from " + oldTargetName + " to " + loser.getLogName());
                }
            }
            return true;
        }
        return false;
    }
}

