/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RideDownEffect
extends OneShotEffect {
    RideDownEffect() {
        super(Outcome.Benefit);
        this.staticText = "Destroy target blocking creature. Creatures that were blocked by that creature this combat gain trample until end of turn";
    }

    private RideDownEffect(RideDownEffect effect) {
        super((OneShotEffect)effect);
    }

    public RideDownEffect copy() {
        return new RideDownEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent blockingCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (blockingCreature != null) {
                for (CombatGroup combatGroup : game.getCombat().getGroups()) {
                    if (!combatGroup.getBlockers().contains(blockingCreature.getId())) continue;
                    for (UUID attackerId : combatGroup.getAttackers()) {
                        GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn);
                        effect.setTargetPointer((TargetPointer)new FixedTarget(attackerId, game));
                        game.addEffect((ContinuousEffect)effect, source);
                    }
                }
                blockingCreature.destroy(source, game, false);
            }
            return true;
        }
        return false;
    }
}

