/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.cards.r.RideTheAvalancheWatcher;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;

class RideTheAvalancheAsThoughEffect
extends AsThoughEffectImpl {
    RideTheAvalancheAsThoughEffect() {
        super(AsThoughEffectType.CAST_AS_INSTANT, Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "The next spell you cast this turn can be cast as though it had flash";
    }

    private RideTheAvalancheAsThoughEffect(RideTheAvalancheAsThoughEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        RideTheAvalancheWatcher.addPlayer(source.getControllerId(), game);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public RideTheAvalancheAsThoughEffect copy() {
        return new RideTheAvalancheAsThoughEffect(this);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        if (!source.isControlledBy(affectedControllerId)) {
            return false;
        }
        if (!RideTheAvalancheWatcher.checkPlayer(affectedControllerId, game)) {
            this.discard();
            return false;
        }
        Card card = game.getCard(sourceId);
        return card != null;
    }
}

