/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

class RideTheAvalancheTriggeredAbility
extends DelayedTriggeredAbility {
    public RideTheAvalancheTriggeredAbility() {
        super(null, Duration.EndOfTurn, true, false);
        this.addTarget((Target)new TargetCreaturePermanent(0, 1));
    }

    private RideTheAvalancheTriggeredAbility(RideTheAvalancheTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Spell spell = game.getSpell(event.getTargetId());
        if (spell == null) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance(spell.getManaValue())));
        return true;
    }

    public RideTheAvalancheTriggeredAbility copy() {
        return new RideTheAvalancheTriggeredAbility(this);
    }

    public String getRule() {
        return "When you next cast a spell this turn, put X +1/+1 counters on up to one target creature, where X is the mana value of that spell.";
    }
}

