/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class RielleTheEverwiseWatcher
extends Watcher {
    private final Map<UUID, Integer> discardedThisTurn = new HashMap<UUID, Integer>();

    RielleTheEverwiseWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.DISCARDED_CARDS && event.getAmount() > 0) {
            this.discardedThisTurn.merge(event.getPlayerId(), 1, Integer::sum);
        }
    }

    public void reset() {
        super.reset();
        this.discardedThisTurn.clear();
    }

    boolean checkDiscarded(UUID playerId) {
        return this.discardedThisTurn.getOrDefault(playerId, 0) < 2;
    }
}

