/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostImpl;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.counters.CounterType;
import mage.filter.common.FilterPermanentOrSuspendedCard;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetPermanentOrSuspendedCard;

class RiftElementalCost
extends CostImpl {
    private static final FilterPermanentOrSuspendedCard filter = new FilterPermanentOrSuspendedCard("permanent you control with a time counter or suspended card you own");

    RiftElementalCost() {
        this.text = "Remove a time counter from a permanent you control or suspended card you own";
    }

    private RiftElementalCost(RiftElementalCost cost) {
        super((CostImpl)cost);
    }

    public boolean pay(Ability ability, Game game, Ability source, UUID controllerId, boolean noMana, Cost costToPay) {
        TargetPermanentOrSuspendedCard target;
        this.paid = false;
        Player controller = game.getPlayer(controllerId);
        if (controller != null && (target = new TargetPermanentOrSuspendedCard(filter, true)).choose(Outcome.Neutral, controllerId, source.getSourceId(), source, game)) {
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent != null) {
                permanent.removeCounters(CounterType.TIME.createInstance(), source, game);
                this.paid = true;
            } else {
                Card card = game.getCard(target.getFirstTarget());
                if (card != null) {
                    card.removeCounters(CounterType.TIME.createInstance(), source, game);
                    this.paid = true;
                }
            }
        }
        return this.paid;
    }

    public boolean canPay(Ability ability, Ability source, UUID controllerId, Game game) {
        TargetPermanentOrSuspendedCard target = new TargetPermanentOrSuspendedCard(filter, true);
        return target.canChooseOrAlreadyChosen(controllerId, source, game);
    }

    public RiftElementalCost copy() {
        return new RiftElementalCost(this);
    }

    static {
        filter.getPermanentFilter().add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        filter.getPermanentFilter().add((Predicate)CounterType.TIME.getPredicate());
        filter.getCardFilter().add((ObjectSourcePlayerPredicate)TargetController.YOU.getOwnerPredicate());
    }
}

