/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RighteousFuryEffect
extends OneShotEffect {
    RighteousFuryEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all tapped creatures. You gain 2 life for each creature destroyed this way";
    }

    private RighteousFuryEffect(RighteousFuryEffect effect) {
        super((OneShotEffect)effect);
    }

    public RighteousFuryEffect copy() {
        return new RighteousFuryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int destroyedCreature = 0;
            FilterCreaturePermanent filter = new FilterCreaturePermanent("all tapped creatures");
            filter.add((Predicate)TappedPredicate.TAPPED);
            for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)filter, controller.getId(), game)) {
                if (!creature.destroy(source, game, false)) continue;
                ++destroyedCreature;
            }
            if (destroyedCreature > 0) {
                game.processAction();
                new GainLifeEffect(destroyedCreature * 2).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

