/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.ExileTopXMayPlayUntilEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.token.BlueBirdToken;
import mage.game.permanent.token.Token;
import mage.game.stack.Spell;

class RikuOfManyPathsTriggeredAbility
extends TriggeredAbilityImpl {
    RikuOfManyPathsTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ExileTopXMayPlayUntilEffect(1, Duration.UntilEndOfYourNextTurn).withTextOptions("it", false));
        this.setTriggerPhrase("Whenever you cast a modal spell, ");
        this.getModes().setChooseText("choose up to X, where X is the number of times you chose a mode for that spell &mdash;");
        this.addMode(new Mode((Effect)new AddCountersSourceEffect(CounterType.P1P1.createInstance())).addEffect((Effect)new GainAbilitySourceEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn).setText("it gains trample until end of turn")));
        this.addMode(new Mode((Effect)new CreateTokenEffect((Token)new BlueBirdToken())));
        this.getModes().setMinModes(0);
    }

    private RikuOfManyPathsTriggeredAbility(RikuOfManyPathsTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RikuOfManyPathsTriggeredAbility copy() {
        return new RikuOfManyPathsTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getSpell(event.getTargetId());
        if (spell == null || !spell.isControlledBy(this.getControllerId()) || spell.getSpellAbility().getModes().size() < 2) {
            return false;
        }
        this.getModes().setMaxModes(spell.getSpellAbility().getModes().getSelectedModes().size());
        return true;
    }
}

