/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RimefeatherOwlEffect
extends ContinuousEffectImpl {
    private final FilterPermanent filter;

    public RimefeatherOwlEffect(Duration duration, FilterPermanent filter) {
        super(duration, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Detriment);
        this.filter = filter;
        this.staticText = "Permanents with ice counters on them are snow.";
    }

    private RimefeatherOwlEffect(RimefeatherOwlEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.filter = effect.filter;
    }

    public RimefeatherOwlEffect copy() {
        return new RimefeatherOwlEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter, source.getControllerId(), source, game)) {
            permanent.addSuperType(game, SuperType.SNOW);
        }
        return true;
    }
}

