/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SpellCastControllerTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.FilterSpell;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.permanent.token.GreenCatToken;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.WhiteDogToken;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;

public final class RinAndSeriInseparable
extends CardImpl {
    private static final FilterSpell dogSpellFilter = new FilterSpell("a Dog spell");
    private static final FilterSpell catSpellFilter = new FilterSpell("a Cat spell");
    private static final FilterPermanent dogPermanentFilter = new FilterControlledPermanent("Dogs you control");
    private static final FilterPermanent catPermanentFilter = new FilterControlledPermanent("Cats you control");

    public RinAndSeriInseparable(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{1}{R}{G}{W}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.DOG);
        this.subtype.add((Object)SubType.CAT);
        this.power = new MageInt(4);
        this.toughness = new MageInt(4);
        this.addAbility((Ability)new SpellCastControllerTriggeredAbility((Effect)new CreateTokenEffect((Token)new GreenCatToken()), dogSpellFilter, false));
        this.addAbility((Ability)new SpellCastControllerTriggeredAbility((Effect)new CreateTokenEffect((Token)new WhiteDogToken()), catSpellFilter, false));
        PermanentsOnBattlefieldCount dogCount = new PermanentsOnBattlefieldCount(dogPermanentFilter);
        DamageTargetEffect damageEffect = new DamageTargetEffect((DynamicValue)dogCount);
        damageEffect.setText("{this} deals damage to any target equal to the number of Dogs you control");
        PermanentsOnBattlefieldCount catCount = new PermanentsOnBattlefieldCount(catPermanentFilter);
        GainLifeEffect lifeGainEffect = new GainLifeEffect((DynamicValue)catCount);
        lifeGainEffect.setText("You gain life equal to the number of Cats you control");
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)damageEffect, (Cost)new ManaCostsImpl("{R}{G}{W}"));
        ability.addEffect((Effect)lifeGainEffect);
        ability.addCost((Cost)new TapSourceCost());
        ability.addTarget((Target)new TargetAnyTarget());
        ability.addHint((Hint)new ValueHint("Dogs you control", (DynamicValue)dogCount));
        ability.addHint((Hint)new ValueHint("Cats you control", (DynamicValue)catCount));
        this.addAbility((Ability)ability);
    }

    private RinAndSeriInseparable(RinAndSeriInseparable card) {
        super((CardImpl)card);
    }

    public RinAndSeriInseparable copy() {
        return new RinAndSeriInseparable(this);
    }

    static {
        dogSpellFilter.add((Predicate)SubType.DOG.getPredicate());
        catSpellFilter.add((Predicate)SubType.CAT.getPredicate());
        dogPermanentFilter.add((Predicate)SubType.DOG.getPredicate());
        catPermanentFilter.add((Predicate)SubType.CAT.getPredicate());
    }
}

