/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Objects;
import java.util.UUID;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.target.common.TargetCardInLibrary;

class RipSpawnHunterTarget
extends TargetCardInLibrary {
    private static final FilterCard filter = new FilterCard("creature and/or Vehicle cards with different powers");

    public RipSpawnHunterTarget() {
        super(0, Integer.MAX_VALUE, filter);
    }

    private RipSpawnHunterTarget(RipSpawnHunterTarget target) {
        super((TargetCardInLibrary)target);
    }

    public RipSpawnHunterTarget copy() {
        return new RipSpawnHunterTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        Card card = game.getCard(id);
        if (card == null) {
            return false;
        }
        int power = card.getPower().getValue();
        return this.getTargets().stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).map(MageObject::getPower).mapToInt(MageInt::getValue).noneMatch(x -> x == power);
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)SubType.VEHICLE.getPredicate()));
    }
}

