/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.r.RipplesOfPotentialWatcher;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;

class RipplesOfPotentialEffect
extends OneShotEffect {
    RipplesOfPotentialEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then choose any number of permanents you control that had a counter put on them this way. Those permanents phase out. <i>(To proliferate, choose any number of permanents and/or players, then give each another counter of each kind already there. Treat phased-out permanents and anything attached to them as though they don't exist until their controller's next turn.)</i>";
    }

    private RipplesOfPotentialEffect(RipplesOfPotentialEffect effect) {
        super((OneShotEffect)effect);
    }

    public RipplesOfPotentialEffect copy() {
        return new RipplesOfPotentialEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        RipplesOfPotentialWatcher watcher = (RipplesOfPotentialWatcher)game.getState().getWatcher(RipplesOfPotentialWatcher.class, source.getSourceId());
        if (watcher == null) {
            return false;
        }
        FilterPermanent filter = new FilterPermanent("permanents");
        filter.add(Predicates.or((Iterable)watcher.getProliferatedPermanents().stream().map(mor -> mor.getPermanentOrLKIBattlefield(game)).filter(Objects::nonNull).filter(permanent -> permanent.isControlledBy(source.getControllerId())).map(MageItem::getId).map(PermanentIdPredicate::new).collect(Collectors.toSet())));
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        controller.choose(this.outcome, target.withChooseHint("to phase out"), source, game);
        for (UUID targetId : target.getTargets()) {
            Permanent permanent2 = game.getPermanent(targetId);
            if (permanent2 == null) continue;
            permanent2.phaseOut(game);
        }
        watcher.reset();
        return true;
    }
}

