/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.CostsImpl;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.cards.Cards;
import mage.cards.r.RipplesOfUndeathReturnEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class RipplesOfUndeathEffect
extends OneShotEffect {
    RipplesOfUndeathEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill three cards. Then you may pay {1} and 3 life. If you do, put a card from among those cards into your hand.";
    }

    private RipplesOfUndeathEffect(RipplesOfUndeathEffect effect) {
        super((OneShotEffect)effect);
    }

    public RipplesOfUndeathEffect copy() {
        return new RipplesOfUndeathEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Cards milled = controller.millCards(3, source, game);
        CostsImpl cost = new CostsImpl();
        cost.add((Object)new GenericManaCost(1));
        cost.add((Object)new PayLifeCost(3));
        new DoIfCostPaid((Effect)new RipplesOfUndeathReturnEffect((Set<UUID>)milled), (Cost)cost).apply(game, source);
        return true;
    }
}

