/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBasePowerSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RiptideManglerEffect
extends OneShotEffect {
    RiptideManglerEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Change {this}'s base power to target creature's power. <i>(This effect lasts indefinitely.)</i>";
    }

    private RiptideManglerEffect(RiptideManglerEffect effect) {
        super((OneShotEffect)effect);
    }

    public RiptideManglerEffect copy() {
        return new RiptideManglerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        game.addEffect((ContinuousEffect)new SetBasePowerSourceEffect(permanent.getPower().getValue(), Duration.Custom), source);
        return true;
    }
}

