/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardTypeTargetEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessTargetEffect;
import mage.cards.r.RiseAndShine;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class RiseAndShineEffect
extends OneShotEffect {
    RiseAndShineEffect() {
        super(Outcome.Benefit);
    }

    private RiseAndShineEffect(RiseAndShineEffect effect) {
        super((OneShotEffect)effect);
    }

    public RiseAndShineEffect copy() {
        return new RiseAndShineEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List permanents = game.getBattlefield().getActivePermanents(RiseAndShine.filter, source.getControllerId(), source, game);
        if (permanents.isEmpty()) {
            return false;
        }
        game.addEffect(new AddCardTypeTargetEffect(Duration.EndOfGame, new CardType[]{CardType.ARTIFACT, CardType.CREATURE}).setTargetPointer((TargetPointer)new FixedTargets((Collection)permanents, game)), source);
        game.addEffect(new SetBasePowerToughnessTargetEffect(0, 0, Duration.EndOfGame).setTargetPointer((TargetPointer)new FixedTargets((Collection)permanents, game)), source);
        for (Permanent permanent : permanents) {
            permanent.addCounters(CounterType.P1P1.createInstance(4), source.getControllerId(), source, game);
        }
        return true;
    }
}

