/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class RisingWatersUntapEffect
extends OneShotEffect {
    RisingWatersUntapEffect() {
        super(Outcome.Untap);
        this.staticText = "that player untaps a land they control";
    }

    private RisingWatersUntapEffect(RisingWatersUntapEffect effect) {
        super((OneShotEffect)effect);
    }

    public RisingWatersUntapEffect copy() {
        return new RisingWatersUntapEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        TargetPermanent target = new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT_LAND);
        if (player == null || !player.chooseTarget(Outcome.Untap, (Target)target, source, game)) {
            return false;
        }
        for (UUID landId : target.getTargets()) {
            Permanent land = game.getPermanent(landId);
            if (land == null) continue;
            land.untap(game);
        }
        return true;
    }
}

