/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class RitesOfInitiationEffect
extends OneShotEffect {
    RitesOfInitiationEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Discard any number of cards at random. Creatures you control get +1/+0 until end of turn for each card discarded this way";
    }

    private RitesOfInitiationEffect(RitesOfInitiationEffect effect) {
        super((OneShotEffect)effect);
    }

    public RitesOfInitiationEffect copy() {
        return new RitesOfInitiationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            int numToDiscard = player.getAmount(0, player.getHand().size(), "Discard how many cards at random?", source, game);
            player.discard(numToDiscard, true, false, source, game);
            game.addEffect((ContinuousEffect)new BoostControlledEffect(numToDiscard, 0, Duration.EndOfTurn), source);
            return true;
        }
        return false;
    }
}

