/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.permanent.token.SaprolingToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class RithTheAwakenerEffect
extends OneShotEffect {
    RithTheAwakenerEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a color, then create a 1/1 green Saproling creature token for each permanent of that color";
    }

    private RithTheAwakenerEffect(RithTheAwakenerEffect effect) {
        super((OneShotEffect)effect);
    }

    public RithTheAwakenerEffect copy() {
        return new RithTheAwakenerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ChoiceColor choice = new ChoiceColor();
        if (controller.choose(this.outcome, (Choice)choice, game)) {
            game.informPlayers(controller.getLogName() + " chooses " + choice.getColor());
            FilterPermanent filter = new FilterPermanent();
            filter.add((Predicate)new ColorPredicate(choice.getColor()));
            int cardsWithColor = game.getBattlefield().count(filter, controller.getId(), source, game);
            if (cardsWithColor > 0) {
                new CreateTokenEffect((Token)new SaprolingToken(), cardsWithColor).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

