/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.CardsInControllerGraveyardCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RiverSerpentEffect
extends RestrictionEffect {
    public RiverSerpentEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack unless there are five or more cards in your graveyard";
    }

    private RiverSerpentEffect(RiverSerpentEffect effect) {
        super((RestrictionEffect)effect);
    }

    public RiverSerpentEffect copy() {
        return new RiverSerpentEffect(this);
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (permanent.getId().equals(source.getSourceId())) {
            return new CardsInControllerGraveyardCount().calculate(game, source, (Effect)this) < 5;
        }
        return false;
    }
}

