/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class RiverwheelSweepEffect
extends OneShotEffect {
    RiverwheelSweepEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile the top two cards of your library. Choose one of them. Until the end of your next turn, you may play that card";
        this.concatBy("<br>");
    }

    private RiverwheelSweepEffect(RiverwheelSweepEffect effect) {
        super((OneShotEffect)effect);
    }

    public RiverwheelSweepEffect copy() {
        return new RiverwheelSweepEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 2));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        cards.retainZone(Zone.EXILED, game);
        switch (cards.size()) {
            case 0: {
                return false;
            }
            case 1: {
                card = cards.getRandom(game);
                break;
            }
            default: {
                TargetCardInExile target = new TargetCardInExile(StaticFilters.FILTER_CARD);
                target.withNotTarget(true);
                player.choose(Outcome.DrawCard, (Cards)cards, (TargetCard)target, source, game);
                card = game.getCard(target.getFirstTarget());
            }
        }
        if (card == null) {
            return false;
        }
        CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.UntilEndOfYourNextTurn, (boolean)false);
        return true;
    }
}

