/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.condition.common.SpectacleCondition;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class RixMaadiRevelerEffect
extends OneShotEffect {
    RixMaadiRevelerEffect() {
        super(Outcome.Benefit);
        this.staticText = "discard a card, then draw a card. If {this}'s spectacle cost was paid, instead discard your hand, then draw three cards.";
    }

    private RixMaadiRevelerEffect(RixMaadiRevelerEffect effect) {
        super((OneShotEffect)effect);
    }

    public RixMaadiRevelerEffect copy() {
        return new RixMaadiRevelerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (SpectacleCondition.instance.apply(game, source)) {
            player.discard(player.getHand().size(), false, false, source, game);
            player.drawCards(3, source, game);
        } else {
            player.discard(1, false, false, source, game);
            player.drawCards(1, source, game);
        }
        return true;
    }
}

