/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.PermanentsOnTheBattlefieldCondition;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeSourceCost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.hint.ConditionHint;
import mage.abilities.hint.Hint;
import mage.abilities.mana.ColorlessManaAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;

public final class RoadsideReliquary
extends CardImpl {
    private static final Condition artifactCondition = new PermanentsOnTheBattlefieldCondition((FilterPermanent)StaticFilters.FILTER_PERMANENT_ARTIFACT);
    private static final Condition enchantmentCondition = new PermanentsOnTheBattlefieldCondition((FilterPermanent)StaticFilters.FILTER_PERMANENT_ENCHANTMENT);
    private static final Hint artifactHint = new ConditionHint(artifactCondition, "You control an artifact");
    private static final Hint enchantmentHint = new ConditionHint(enchantmentCondition, "You control an enchantment");

    public RoadsideReliquary(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.LAND}, "");
        this.addAbility((Ability)new ColorlessManaAbility());
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new ConditionalOneShotEffect((OneShotEffect)new DrawCardSourceControllerEffect(1), artifactCondition, "Draw a card if you control an artifact"), (Cost)new GenericManaCost(2));
        ability.addCost((Cost)new TapSourceCost());
        ability.addCost((Cost)new SacrificeSourceCost());
        ability.addEffect((Effect)new ConditionalOneShotEffect((OneShotEffect)new DrawCardSourceControllerEffect(1), enchantmentCondition, "Draw a card if you control an enchantment"));
        ability.addHint(artifactHint);
        ability.addHint(enchantmentHint);
        this.addAbility((Ability)ability);
    }

    private RoadsideReliquary(RoadsideReliquary card) {
        super((CardImpl)card);
    }

    public RoadsideReliquary copy() {
        return new RoadsideReliquary(this);
    }
}

