/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class RoamingThroneReplacementEffect
extends ReplacementEffectImpl {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent();

    RoamingThroneReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a triggered ability of another creature you control of the chosen type triggers, it triggers an additional time";
    }

    private RoamingThroneReplacementEffect(RoamingThroneReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public RoamingThroneReplacementEffect copy() {
        return new RoamingThroneReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!source.isControlledBy(event.getPlayerId())) {
            return false;
        }
        Permanent permanentSource = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return permanentSource != null && filter.match(permanentSource, source.getControllerId(), source, game) && permanentSource.hasSubtype(ChooseCreatureTypeEffect.getChosenCreatureType((UUID)source.getSourceId(), (Game)game), game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)1));
        return false;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

