/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.BasicManaAbility;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RobaranMercenariesEffect
extends ContinuousEffectImpl {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent();

    RobaranMercenariesEffect() {
        super(Duration.WhileOnBattlefield, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "{this} has all activated abilities of all legendary creatures you control.";
        this.addDependencyType(DependencyType.AddingAbility);
    }

    private RobaranMercenariesEffect(RobaranMercenariesEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent perm = game.getPermanent(source.getSourceId());
        if (perm == null) {
            return false;
        }
        for (Ability ability2 : game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game).stream().map(permanent -> permanent.getAbilities(game)).flatMap(Collection::stream).filter(Objects::nonNull).filter(ability -> ability.isActivatedAbility()).collect(Collectors.toList())) {
            if (ability2 instanceof BasicManaAbility) {
                if (!perm.getAbilities(game).stream().noneMatch(ability2.getClass()::isInstance)) continue;
            }
            perm.addAbility(ability2, source.getSourceId(), game, true);
        }
        return true;
    }

    public RobaranMercenariesEffect copy() {
        return new RobaranMercenariesEffect(this);
    }

    static {
        filter.add((Predicate)SuperType.LEGENDARY.getPredicate());
    }
}

