/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class RoccoStreetChefEffect
extends OneShotEffect {
    RoccoStreetChefEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player exiles the top card of their library. Until your next end step, each player may play the card they exiled this way";
    }

    private RoccoStreetChefEffect(RoccoStreetChefEffect effect) {
        super((OneShotEffect)effect);
    }

    public RoccoStreetChefEffect copy() {
        return new RoccoStreetChefEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Card card;
            Player player = game.getPlayer(playerId);
            if (player == null || (card = player.getLibrary().getFromTop(game)) == null) continue;
            player.moveCards(card, Zone.EXILED, source, game);
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.UntilYourNextEndStep, (boolean)false, (UUID)playerId, null);
        }
        return true;
    }
}

