/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.UntapSourceEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class RodOfSpankingEffect
extends OneShotEffect {
    RodOfSpankingEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 1 damage to target player. Then untap {this} unless that player says \"Thank you, sir. May I have another?\"";
    }

    private RodOfSpankingEffect(RodOfSpankingEffect effect) {
        super((OneShotEffect)effect);
    }

    public RodOfSpankingEffect copy() {
        return new RodOfSpankingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player target = game.getPlayer(source.getFirstTarget());
        new DamageTargetEffect(1).apply(game, source);
        if (target != null) {
            if (target.chooseUse(Outcome.Untap, "Say \"Thank you, sir. May I have another?\"", source, game)) {
                game.informPlayers(target.getLogName() + ": Thank you, sir. May I have another?");
            } else {
                new UntapSourceEffect().apply(game, source);
            }
            return true;
        }
        return false;
    }
}

