/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.r.RogueClassLookEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class RogueClassExileEffect
extends OneShotEffect {
    RogueClassExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of that player's library face down. You may look at it for as long as it remains exiled";
    }

    private RogueClassExileEffect(RogueClassExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public RogueClassExileEffect copy() {
        return new RogueClassExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || opponent == null || sourceObject == null) {
            return false;
        }
        Card card = opponent.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        UUID exileZoneId = CardUtil.getExileZoneId((Game)game, (UUID)sourceObject.getId(), (int)sourceObject.getZoneChangeCounter(game));
        if (controller.moveCardsToExile(card, source, game, false, exileZoneId, sourceObject.getIdName())) {
            card.setFaceDown(true, game);
            game.addEffect(new RogueClassLookEffect().setTargetPointer((TargetPointer)new FixedTarget(card, game)), source);
            game.getState().setValue(card.getId().toString() + game.getState().getZoneChangeCounter(card.getId()), (Object)exileZoneId);
            return true;
        }
        return false;
    }
}

