/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.assignment.common.ColorAssignment;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorlessPredicate;
import mage.game.Game;
import mage.target.common.TargetCardInYourGraveyard;

class RoguesGalleryTarget
extends TargetCardInYourGraveyard {
    private static final ColorAssignment colorAssigner = new ColorAssignment(new String[]{"W", "U", "B", "R", "G"});
    private static final FilterCard filter = new FilterCreatureCard("a creature card of each color");

    RoguesGalleryTarget() {
        super(0, Integer.MAX_VALUE, filter);
    }

    private RoguesGalleryTarget(RoguesGalleryTarget target) {
        super((TargetCardInYourGraveyard)target);
    }

    public RoguesGalleryTarget copy() {
        return new RoguesGalleryTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability ability, Game game) {
        if (!super.canTarget(playerId, id, ability, game)) {
            return false;
        }
        Card card = game.getCard(id);
        if (card == null) {
            return false;
        }
        if (this.getTargets().isEmpty()) {
            return true;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargets());
        cards.add(card);
        return colorAssigner.getRoleCount((Cards)cards, game) >= cards.size();
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set possibleTargets = super.possibleTargets(sourceControllerId, source, game);
        possibleTargets.removeIf(uuid -> !this.canTarget(sourceControllerId, (UUID)uuid, source, game));
        return possibleTargets;
    }

    static {
        filter.add(Predicates.not((Predicate)ColorlessPredicate.instance));
    }
}

