/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.game.Game;
import mage.players.Player;

class RoilingHorrorDynamicValue
implements DynamicValue {
    RoilingHorrorDynamicValue() {
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        int opponentsMostLife = Integer.MIN_VALUE;
        Player controller = game.getPlayer(sourceAbility.getControllerId());
        if (controller != null) {
            for (UUID playerUUID : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player opponent;
                if (!controller.hasOpponent(playerUUID, game) || (opponent = game.getPlayer(playerUUID)) == null || opponent.getLife() <= opponentsMostLife) continue;
                opponentsMostLife = opponent.getLife();
            }
            return controller.getLife() - opponentsMostLife;
        }
        return 0;
    }

    public DynamicValue copy() {
        return this;
    }

    public String toString() {
        return "X";
    }

    public String getMessage() {
        return "your life total minus the life total of an opponent with the most life";
    }
}

